/*
 * usart0.c
 *
 *  Created on: 09.09.2014
 *      Author: nxp75900
 */


/***************************************************************************/
/*  USART0 (polling) driver for NXP LPC54xx microcontrollers.             */
/***************************************************************************/
#include "global.h"


const char ascii[] = "0123456789ABCDEF";

void USART0_Init(void)
/***************************/
{

	Chip_UART_Init(LPC_USART0);
	Chip_UART_ConfigData(LPC_USART0, UART_CFG_DATALEN_8 | UART_CFG_PARITY_NONE | UART_CFG_STOPLEN_1);
	Chip_UART_SetBaud(LPC_USART0, 19200);
	Chip_UART_Enable(LPC_USART0);
	Chip_UART_TXEnable(LPC_USART0);
}

char ua_inchar(void)	                           				// look if there is a character available
/******************/
{
    if (LPC_USART0->STAT & (1<<0))
        return LPC_USART0->FIFORD & 0x7F;           			// yes, return character from input buffer
    else
        return 0xFF;                               				// no, return -1
}

char ua_getchar(void)                              				// wait for a character
/*******************/
{
    while (!(LPC_USART0->STAT & (1<<0))) ;          			// receiver ready?
    return LPC_USART0->FIFORD & 0x7F;               			// read character from input buffer
}

void ua_outchar(char c)
/*********************/
{
    while (!(LPC_USART0->STAT & (1<<2))) ;          			// transmitter ready?
    LPC_USART0->FIFOWR = c;
}

void PrintByte(unsigned char b)
/*****************************/
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
/******************************/
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

void PrintString(const char *s)
/*****************************/
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                      			// output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
